@extends('layouts.app')

@section('title', 'All Patients')

@section('content')
<div class="max-w-7xl mx-auto px-2 sm:px-4 lg:px-8">
    <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-4 sm:mb-6 gap-3">
        <h1 class="text-2xl sm:text-3xl font-bold text-gray-800">All Patients</h1>
        <a href="{{ route('admin.dashboard') }}" class="bg-gray-600 hover:bg-gray-700 text-white px-3 sm:px-4 py-2 rounded text-sm sm:text-base">
            <i class="fas fa-arrow-left"></i> <span class="hidden sm:inline">Back to Dashboard</span><span class="sm:hidden">Back</span>
        </a>
    </div>

    @if(session('success'))
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
            {{ session('success') }}
        </div>
    @endif

    <div class="bg-white rounded-lg shadow overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Patient ID</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Name</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase hidden md:table-cell">Gender</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase hidden lg:table-cell">Date of Birth</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase hidden md:table-cell">Phone</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase hidden lg:table-cell">Email</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Appointments</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Prescriptions</th>
                    </tr>
                </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                @forelse($patients as $patient)
                <tr>
                    <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                        <span class="font-medium text-sm sm:text-base">{{ $patient->patient_id }}</span>
                    </td>
                    <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                        <div>
                            <div class="font-medium text-sm sm:text-base">{{ $patient->full_name }}</div>
                            @if($patient->identity_number)
                                <div class="text-xs sm:text-sm text-gray-500">ID: {{ $patient->identity_number }}</div>
                            @endif
                        </div>
                    </td>
                    <td class="px-3 sm:px-6 py-4 whitespace-nowrap hidden md:table-cell">
                        <span class="text-sm">{{ $patient->gender ?? 'N/A' }}</span>
                    </td>
                    <td class="px-3 sm:px-6 py-4 whitespace-nowrap hidden lg:table-cell">
                        <span class="text-sm">{{ $patient->date_of_birth ? $patient->date_of_birth->format('M d, Y') : 'N/A' }}</span>
                    </td>
                    <td class="px-3 sm:px-6 py-4 whitespace-nowrap hidden md:table-cell">
                        <span class="text-sm">{{ $patient->full_phone ?? 'N/A' }}</span>
                    </td>
                    <td class="px-3 sm:px-6 py-4 whitespace-nowrap hidden lg:table-cell">
                        <span class="text-sm">{{ $patient->email ?? 'N/A' }}</span>
                    </td>
                    <td class="px-3 sm:px-6 py-4 whitespace-nowrap text-center">
                        <span class="bg-blue-100 text-blue-800 px-2 py-1 rounded text-xs sm:text-sm">
                            {{ $patient->appointments_count }}
                        </span>
                    </td>
                    <td class="px-3 sm:px-6 py-4 whitespace-nowrap text-center">
                        <span class="bg-green-100 text-green-800 px-2 py-1 rounded text-xs sm:text-sm">
                            {{ $patient->prescriptions_count }}
                        </span>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="8" class="px-6 py-4 text-center text-gray-500">
                        No patients found.
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
        </div>
    </div>

    @if($patients->count() > 0)
    <div class="mt-4 text-sm text-gray-600">
        Showing {{ $patients->count() }} patient(s)
    </div>
    @endif
</div>
@endsection

